/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.dynamicjava;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(SourceWatcher.class);
    private final String name;
    private final WatchService watcher;
    private final AtomicBoolean sourcesChanged;
    private final List<WatchRoot> roots;
    private Thread thread;

    public SourceWatcher(String name) throws IOException {
        this.name = name;
        this.watcher = FileSystems.getDefault().newWatchService();
        this.sourcesChanged = new AtomicBoolean(true);
        this.roots = new ArrayList<WatchRoot>();
    }

    public boolean hasSourcesChanged() {
        return this.sourcesChanged.getAndSet(false);
    }

    public void registerRoot(Path root) throws IOException {
        WatchRoot r = new WatchRoot(root);
        this.roots.add(r);
        r.register(this.watcher);
    }

    public synchronized void start() {
        Preconditions.checkState(this.thread == null, "Watch thread for %s is already started.", (Object)this.name);
        LOG.debug("Starting watcher {}.", (Object)this.name);
        this.thread = new Thread(() -> {
            while (this.watchOnce()) {
            }
            for (WatchRoot root : this.roots) {
                root.close();
            }
            this.roots.clear();
            while (this.watcher.poll() != null) {
            }
            LOG.debug("Watcher {} terminated.", (Object)this.name);
        }, this.name + " watcher");
        this.thread.start();
        LOG.debug("Watcher {} started.", (Object)this.name);
    }

    public synchronized void stop() {
        if (this.thread == null) {
            return;
        }
        try {
            this.thread.interrupt();
            this.thread.join();
        }
        catch (InterruptedException ignored) {
            LOG.warn("Cannot stop watcher thread {}.", (Object)this.name);
        }
        finally {
            this.thread = null;
        }
    }

    private boolean watchOnce() {
        WatchKey key;
        try {
            key = this.watcher.take();
        }
        catch (InterruptedException x) {
            return false;
        }
        return this.processEvents(key);
    }

    private synchronized boolean processEvents(WatchKey key) {
        for (WatchEvent<Path> watchEvent : key.pollEvents()) {
            WatchEvent.Kind<?> kind = watchEvent.kind();
            if (kind == StandardWatchEventKinds.OVERFLOW) continue;
            for (WatchRoot root : this.roots) {
                try {
                    if (!root.handleEvent(this.watcher, key, watchEvent)) continue;
                    this.sourcesChanged.set(true);
                }
                catch (IOException e) {
                    LOG.warn("Cannot handle event", e);
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            for (WatchRoot root : this.roots) {
                root.removeKey(key);
            }
        }
        return true;
    }

    private static class WatchRoot {
        private final Path root;
        private Path parent;
        private final Map<WatchKey, Path> keys;

        WatchRoot(Path root) {
            this.root = root;
            this.parent = WatchRoot.existingParent(root).orElseThrow(() -> new IllegalArgumentException("Cannot find any existing parent of " + root));
            this.keys = new HashMap<WatchKey, Path>();
        }

        static Optional<Path> existingParent(Path dir) {
            while ((dir = dir.getParent()) != null && !Files.exists(dir, new LinkOption[0])) {
            }
            return Optional.ofNullable(dir);
        }

        boolean register(WatchService watcher) throws IOException {
            Path d = this.parent;
            do {
                this.registerDir(watcher, d);
            } while ((d = d.getParent()) != null);
            if (Files.exists(this.root, new LinkOption[0])) {
                this.registerDirRecursive(watcher, this.root);
                return true;
            }
            return false;
        }

        private void registerDir(WatchService watcher, Path dir) throws IOException {
            WatchKey key = dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.keys.put(key, dir);
        }

        private void registerDirRecursive(final WatchService watcher, Path dir) throws IOException {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    this.registerDir(watcher, dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        private void unregisterDirRecursive(Path dir) {
            this.keys.values().removeIf(path -> path.startsWith(dir));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean handleEvent(WatchService watcher, WatchKey key, WatchEvent<Path> event) throws IOException {
            block14: {
                Path dir = this.keys.get(key);
                if (dir == null) {
                    return false;
                }
                Path child = dir.resolve(event.context());
                LOG.debug("{}: {}", (Object)event.kind(), (Object)child);
                if (!this.parent.startsWith(dir) || event.kind() != StandardWatchEventKinds.ENTRY_CREATE && event.kind() != StandardWatchEventKinds.ENTRY_DELETE || !this.root.startsWith(child) || event.kind() != StandardWatchEventKinds.ENTRY_DELETE && (this.root.equals(child) || !Files.isDirectory(child, new LinkOption[0]))) {
                    if (child.startsWith(this.root)) {
                        if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE && Files.isDirectory(child, new LinkOption[0])) {
                            this.registerDirRecursive(watcher, child);
                        }
                        if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                            this.unregisterDirRecursive(child);
                        }
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                break block14;
                finally {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("State: {} {}", (Object)this.parent, (Object)this.keys.values().stream().sorted().collect(Collectors.toList()));
                    }
                }
            }
            boolean rootWasRegistered = this.keys.containsValue(this.root);
            this.unregisterDirRecursive(this.parent);
            while (true) {
                try {
                    this.parent = WatchRoot.existingParent(this.root).orElseThrow();
                    boolean bl = this.register(watcher) ^ rootWasRegistered;
                    return bl;
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }

        void removeKey(WatchKey key) {
            Path dir = this.keys.remove(key);
            if (dir != null) {
                LOG.debug("Removed watch key {}", (Object)dir);
            }
        }

        void close() {
            for (WatchKey key : this.keys.keySet()) {
                key.cancel();
            }
            this.keys.clear();
        }
    }
}

